package com.yd.csf.service.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Date;
import lombok.Data;

/**
 * 新单跟进表
 * @TableName policy_follow
 */
@TableName(value ="policy_follow")
@Data
public class PolicyFollow implements Serializable {
    /**
     * id
     */
    @TableId(type = IdType.AUTO)
    private Long id;

    /**
     * 新单跟进唯一业务ID
     */
    private String policyBizId;

    /**
     * 保单号
     */
    private String policyNo;

    /**
     * 用户业务id
     */
    private String userBizId;

    private String customerBizId;

    private String customerName;

    /**
     * 签单日期
     */
    private LocalDate signDate;

    /**
     * 签单人
     */
    private String signer;

    /**
     * 生效日期
     */
    private LocalDate effectiveDate;

    /**
     * 续保日期
     */
    private LocalDate renewalDate;

    /**
     * 供款年期
     */
    private Integer paymentTerm;

    /**
     * 期交保费
     */
    private BigDecimal paymentPremium;

    /**
     * 产品名称
     */
    private String productName;

    /**
     * 保险公司
     */
    private String insurer;

    /**
     * 保险公司业务id
     */
    private String insurerBizId;

    /**
     * 对账公司
     */
    private String reconciliationCompany;

    /**
     * 对账公司业务id
     */
    private String reconciliationCompanyBizId;

    /**
     * 新单跟进状态
     */
    private String status;

    /**
     * 保單持有人
     */
    private String policyHolder;

    /**
     * 受保人
     */
    private String insured;

    /**
     * 币种
     */
    private String currency;

    /**
     * 首期保费（不含徽费，预缴保费）
     */
    private Object initialPremium;

    /**
     * 通用备注
     */
    private String remark;

    /**
     * 删除标识: 0-正常, 1-删除
     */
    private Integer isDeleted;

    /**
     * 创建人ID
     */
    private String creatorId;

    /**
     * 更新人ID
     */
    private String updaterId;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 更新时间
     */
    private Date updateTime;

    @TableField(exist = false)
    private static final long serialVersionUID = 1L;
}