package com.yd.csf.api.controller;

import com.yd.common.result.Result;
import com.yd.csf.api.service.ApiSecondHolderService;
import com.yd.csf.feign.client.secondholder.ApiSecondHolderFeignClient;
import com.yd.csf.feign.dto.appointment.ApiSecondHolderInfoDto;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.validation.constraints.NotBlank;

/**
 * 预约-第二持有人信息
 *
 * @author zxm
 * @since 2025-09-01
 */
@RestController
@RequestMapping("/secondHolder")
@Validated
public class ApiSecondHolderController implements ApiSecondHolderFeignClient {

    @Autowired
    private ApiSecondHolderService apiSecondHolderService;

    /**
     * 编辑第二持有人信息
     * @param apiSecondHolderInfoDto
     * @return
     */
    @Override
    public Result edit(ApiSecondHolderInfoDto apiSecondHolderInfoDto) {
        return apiSecondHolderService.edit(apiSecondHolderInfoDto);
    }

    /**
     * 第二持有人信息详情
     * @param appointmentBizId 预约信息主表唯一业务ID
     * @param secondHolderBizId 第二持有人信息表唯一业务ID
     * @return
     */
    @Override
    public Result<ApiSecondHolderInfoDto> detail(String appointmentBizId, String secondHolderBizId) {
        return apiSecondHolderService.detail(appointmentBizId,secondHolderBizId);
    }


}
