package com.yd.csf.api.listener;

import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.event.AnalysisEventListener;
import com.yd.csf.api.dto.PolicyExcelDTO;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;

@Component
@Slf4j
public class PolicyDataListener extends AnalysisEventListener<PolicyExcelDTO> {

    private List<PolicyExcelDTO> list = new ArrayList<>();

    @Override
    public void invoke(PolicyExcelDTO policy, AnalysisContext context) {
        list.add(policy);
    }

    @Override
    public void doAfterAllAnalysed(AnalysisContext context) {
        log.info("读取到 {} 条保单数据", list.size());
        // 这里可以调用Service进行数据保存
    }

    public List<PolicyExcelDTO> getList() {
        return list;
    }
}
