package com.yd.csf.feign.client.formulaconfig;

import com.yd.common.result.Result;
import com.yd.csf.feign.fallback.formulaconfig.ApiFormulaConfigFeignFallbackFactory;
import com.yd.csf.feign.request.formulaconfig.ApiFormulaConfigAddRequest;
import com.yd.csf.feign.request.formulaconfig.ApiFormulaConfigEditRequest;
import com.yd.csf.feign.request.formulaconfig.ApiFormulaConfigPageRequest;
import com.yd.csf.feign.response.formulaconfig.ApiFormulaConfigDetailResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import javax.validation.constraints.NotBlank;

/**
 * 香港保险服务-公式配置信息Feign客户端
 */
@FeignClient(name = "yd-csf-api", fallbackFactory = ApiFormulaConfigFeignFallbackFactory.class)
public interface ApiFormulaConfigFeignClient {

    /**
     * 分页查询-公式配置信息
     * @param request
     * @return
     */
    @PostMapping("/page")
    Result page(@RequestBody ApiFormulaConfigPageRequest request);

    /**
     * 详情-公式配置信息
     * @param formulaBizId
     * @return
     */
    @GetMapping("/detail")
    Result<ApiFormulaConfigDetailResponse> detail(@NotBlank(message = "公式配置信息表唯一业务ID不能为空不能为空") @RequestParam(value = "formulaBizId") String formulaBizId);

    /**
     * 添加-公式配置信息
     * @param request
     * @return
     */
    @PostMapping("/add")
    Result add(@Validated @RequestBody ApiFormulaConfigAddRequest request);

    /**
     * 编辑-公式配置信息
     * @param request
     * @return
     */
    @PutMapping("/edit")
    Result edit(@Validated @RequestBody ApiFormulaConfigEditRequest request);

    /**
     * 删除-公式配置信息 TODO
     * @param formulaBizId
     * @return
     */
    @DeleteMapping("/del")
    Result del(@NotBlank(message = "公式配置信息表唯一业务ID不能为空不能为空") @RequestParam(value = "formulaBizId") String formulaBizId);
}
