package com.yd.csf.feign.request.variable;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

@Data
public class ApiVariableEditRequest {

    /**
     * 变量表唯一业务ID
     */
    @NotBlank(message = "变量表唯一业务ID不能为空")
    private String variableBizId;

    /**
     * 变量名称中文名
     */
    @NotBlank(message = "变量名称中文名不能为空")
    private String nameCn;

    /**
     * 变量名称英文名
     */
    @NotBlank(message = "变量名称英文名不能为空")
    private String nameEn;

    /**
     * 变量类型（字典: 固定值、动态计算，如果固定值这个变量取值就是value变量值这个字段，如果是动态计算需要关联条件（对象和条件配置关系表）和SQL计算（对象和SQL模板配置关系表）对应的变量值）
     */
    @NotBlank(message = "变量类型不能为空")
    private String type;

    /**
     * 变量值
     */
    @NotBlank(message = "变量值不能为空")
    private String value;

    /**
     * 状态(0:停用 1:启用)
     */
    @NotNull(message = "状态不能为空")
    private Integer status;

    /**
     * 绑定的条件类型业务ID
     */
    private String conditionTypeBizId;

    /**
     * 绑定SQL模板表唯一业务ID
     */
    private String sqlTemplateBizId;

    //    /**
//     * 所属租户唯一业务ID（冗余）
//     */
//    private String tenantBizId;
//
//    /**
//     * 所属项目唯一业务ID（冗余）
//     */
//    private String projectBizId;
}
