package com.yd.csf.feign.fallback.premiumreconciliation;

import com.yd.common.result.Result;
import com.yd.csf.feign.client.premiumreconciliation.ApiPremiumReconciliationFeignClient;
import com.yd.csf.feign.dto.premiumreconciliation.ApiPremiumReconciliationDto;
import com.yd.csf.feign.request.premiumreconciliation.ApiPremiumReconciliationAddRequest;
import com.yd.csf.feign.request.premiumreconciliation.ApiPremiumReconciliationPageRequest;
import com.yd.csf.feign.request.premiumreconciliation.ApiPremiumReconciliationResultEditRequest;
import com.yd.csf.feign.request.premiumreconciliation.ApiCalculateRemainingUnpaidAmountRequest;
import com.yd.csf.feign.response.premiumreconciliation.ApiPremiumReconciliationDetailResponse;
import com.yd.csf.feign.response.premiumreconciliation.ApiCalculateRemainingUnpaidAmountResponse;
import lombok.extern.slf4j.Slf4j;
import org.springframework.cloud.openfeign.FallbackFactory;
import org.springframework.stereotype.Component;

import javax.validation.constraints.NotBlank;

/**
 * 香港保险服务-保费对账记录信息Feign降级处理
 */
@Slf4j
@Component
public class ApiPremiumReconciliationFeignFallbackFactory implements FallbackFactory<ApiPremiumReconciliationFeignClient> {
    @Override
    public ApiPremiumReconciliationFeignClient create(Throwable cause) {
        return new ApiPremiumReconciliationFeignClient() {
            @Override
            public Result page(ApiPremiumReconciliationPageRequest request) {
                return null;
            }

            @Override
            public Result add(ApiPremiumReconciliationAddRequest request) {
                return null;
            }

            @Override
            public Result edit(ApiPremiumReconciliationDto request) {
                return null;
            }

            @Override
            public Result<ApiPremiumReconciliationDetailResponse> detail(String premiumReconciliationBizId) {
                return null;
            }

            @Override
            public Result<ApiCalculateRemainingUnpaidAmountResponse> calculateRemainingUnpaidAmount(ApiCalculateRemainingUnpaidAmountRequest request) {
                return null;
            }

            @Override
            public Result editResult(ApiPremiumReconciliationResultEditRequest request) {
                return null;
            }

            @Override
            public Result<Boolean> checkReconciliationComplete(String policyNo) {
                return null;
            }
        };
    }
}
