package com.yd.csf.api.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yd.common.result.Result;
import com.yd.common.utils.RandomStringGenerator;
import com.yd.csf.service.common.ErrorCode;
import com.yd.csf.service.dto.FnaFormAddRequest;
import com.yd.csf.service.dto.FnaFormQueryRequest;
import com.yd.csf.service.model.FnaForm;
import com.yd.csf.service.service.FnaFormService;
import com.yd.csf.service.vo.FnaFormVO;
import com.yd.user.feign.client.sysuser.ApiSysUserFeignClient;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;

/**
 * Fna表单接口
 *
 * @author jianan
 * @since 2025-08-31
 */
@RestController
@RequestMapping("/FnaForm")
@Tag(name = "Fna表单接口")
public class ApiFnaFormController {

    @Resource
    private FnaFormService fnaFormService;

    @Resource
    private ApiSysUserFeignClient apiSysUserFeignClient;

    /**
     * 创建 Fna表单
     *
     * @param fnaFormAddRequest
     * @param request
     * @return
     */
    @PostMapping("/add")
    public Result<String> addFnaForm(@RequestBody FnaFormAddRequest fnaFormAddRequest, HttpServletRequest request) {

        if (fnaFormAddRequest == null) {
            return Result.fail(ErrorCode.PARAMS_ERROR.getCode(), ErrorCode.PARAMS_ERROR.getMessage());
        }
        // 校验
        fnaFormService.validFnaFormAdd(fnaFormAddRequest);
        // 转换为数据库实体
        FnaForm fnaForm = fnaFormService.getFnaForm(fnaFormAddRequest);

        // 获取Security上下文当前用户的登录信息
//        AuthUserDto authUserDto = SecurityUtil.getCurrentLoginUser();
//        String userBizId = authUserDto.getUserBizId();

        String userBizId = "user_dMnkKPIwemvY0zhk";

        fnaForm.setUserBizId(userBizId);
        fnaForm.setFnaFormBizId(RandomStringGenerator.generateBizId16("fna_form"));

        fnaForm.setCreatorId(userBizId);
        fnaForm.setUpdaterId(userBizId);
        // 写入数据库
        boolean result = fnaFormService.save(fnaForm);
        if (!result) {
            return Result.fail(ErrorCode.OPERATION_ERROR.getCode(), ErrorCode.OPERATION_ERROR.getMessage());
        }

        // 返回新写入的数据 id
        String newFnaFormId = fnaForm.getFnaFormBizId();
        return Result.success(newFnaFormId);
    }

    /**
     * 删除fna
     *
     * @param deleteRequest
     * @param request
     * @return
     */
//    @PostMapping("/delete")
//    public Result<Boolean> deleteFna(@RequestBody DeleteRequest deleteRequest, HttpServletRequest request) {
//        if (deleteRequest == null || deleteRequest.getId() <= 0) {
//            throw new BusinessException(ErrorCode.PARAMS_ERROR);
//        }
//        User user = userService.getLoginUser(request);
//        long id = deleteRequest.getId();
//        // 判断是否存在
//        FnaForm oldFna = fnaFormService.getById(id);
//        ThrowUtils.throwIf(oldFna == null, ErrorCode.NOT_FOUND_ERROR);
//        // 仅本人或管理员可删除
//        if (!oldFna.getUserId().equals(user.getId()) && !userService.isAdmin(request)) {
//            throw new BusinessException(ErrorCode.NO_AUTH_ERROR);
//        }
//        // 操作数据库
//        boolean result = fnaFormService.removeById(id);
//        ThrowUtils.throwIf(!result, ErrorCode.OPERATION_ERROR);
//        return Result.success(true);
//    }

    /**
     * 更新fna（仅管理员可用）
     *
     * @param fnaUpdateRequest
     * @return
     */
//    @PostMapping("/update")
//    @AuthCheck(mustRole = UserConstant.ADMIN_ROLE)
//    public Result<Boolean> updateFna(@RequestBody FnaUpdateRequest fnaUpdateRequest) {
//        if (fnaUpdateRequest == null || fnaUpdateRequest.getId() <= 0) {
//            throw new BusinessException(ErrorCode.PARAMS_ERROR);
//        }
//        // todo 在此处将实体类和 DTO 进行转换
//        FnaForm fnaForm = new FnaForm();
//        BeanUtils.copyProperties(fnaUpdateRequest, fnaForm);
//        // 数据校验
//        fnaFormService.validFna(fnaForm, false);
//        // 判断是否存在
//        long id = fnaUpdateRequest.getId();
//        FnaForm oldFna = fnaFormService.getById(id);
//        ThrowUtils.throwIf(oldFna == null, ErrorCode.NOT_FOUND_ERROR);
//        // 操作数据库
//        boolean result = fnaFormService.updateById(fnaForm);
//        ThrowUtils.throwIf(!result, ErrorCode.OPERATION_ERROR);
//        return Result.success(true);
//    }

    /**
     * 根据 fnaFormBizId 获取fna表单（封装类）
     *
     * @param fnaFormBizId
     * @return
     */
    @GetMapping("/get/vo")
    @Operation(summary = "根据 fnaFormBizId 获取Fna表单详情")
    public Result<FnaFormVO> getFnaFormVOByFnaFormBizId(String fnaFormBizId, HttpServletRequest request) {
        if (fnaFormBizId == null) {
            return Result.fail(ErrorCode.PARAMS_ERROR.getCode(), ErrorCode.PARAMS_ERROR.getMessage());
        }
        // 查询数据库
        FnaForm fnaForm = fnaFormService.getByFnaFormBizId(fnaFormBizId);
        if (fnaForm == null) {
            return Result.fail(ErrorCode.NOT_FOUND_ERROR.getCode(), ErrorCode.NOT_FOUND_ERROR.getMessage());
        }

        // 获取封装类
        return Result.success(fnaFormService.getFnaFormVO(fnaForm));
    }
    /**
     * 分页获取fna表单列表（仅管理员可用）
     *
     * @param fnaFormQueryRequest
     * @return
     */
//    @PostMapping("/list/page")
//    public Result<Page<FnaForm>> listFnaFormByPage(@RequestBody FnaFormQueryRequest fnaFormQueryRequest) {
//        long current = fnaFormQueryRequest.getPageNo();
//        long size = fnaFormQueryRequest.getPageSize();
//        // 查询数据库
//        Page<FnaForm> fnaPage = fnaFormService.page(new Page<>(current, size),
//                fnaFormService.getQueryWrapper(fnaFormQueryRequest));
//        return Result.success(fnaPage);
//    }

    /**
     * 分页获取fna表单列表（封装类）
     *
     * @param fnaFormQueryRequest
     * @param request
     * @return
     */
//    @PostMapping("/list/page/vo")
//    public Result<Page<FnaForm>> listFnaFormVOByPage(@RequestBody FnaFormQueryRequest fnaFormQueryRequest,
//                                             HttpServletRequest request) {
//        long current = fnaFormQueryRequest.getPageNo();
//        long size = fnaFormQueryRequest.getPageSize();
//
//        // 查询数据库
//        Page<FnaForm> fnaPage = fnaFormService.page(new Page<>(current, size),
//                fnaFormService.getQueryWrapper(fnaFormQueryRequest));
//        // 获取封装类
////        return Result.success(fnaFormService.getFnaVOPage(fnaPage, request));
//
//        return Result.success(fnaPage);
//    }

}
