package com.yd.csf.feign.client.additional;

import com.yd.common.result.Result;
import com.yd.csf.feign.dto.appointment.ApiProductPlanAdditionalInfoDto;
import com.yd.csf.feign.fallback.additional.ApiAdditionalFeignFallbackFactory;
import com.yd.csf.feign.request.additional.ApiAdditionalPageRequest;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import javax.validation.constraints.NotBlank;

/**
 * 香港保险服务-产品计划-附加险信息Feign客户端
 */
@FeignClient(name = "yd-csf-api", fallbackFactory = ApiAdditionalFeignFallbackFactory.class)
public interface ApiAdditionalFeignClient {

    /**
     * 附加险分页查询
     * @param request
     * @return
     */
    @PostMapping("/page")
    Result page(@RequestBody ApiAdditionalPageRequest request);

    /**
     * 新增单个附加险信息
     * @param apiProductPlanAdditionalInfoDto
     * @return
     */
    @PostMapping("/add")
    Result add(@Validated @RequestBody ApiProductPlanAdditionalInfoDto apiProductPlanAdditionalInfoDto);

    /**
     * 编辑单个附加险信息
     * @param apiProductPlanAdditionalInfoDto
     * @return
     */
    @PutMapping("/edit")
    Result edit(@Validated @RequestBody ApiProductPlanAdditionalInfoDto apiProductPlanAdditionalInfoDto);

    /**
     * 单个附加险信息详情
     * @param additionalBizId
     * @return
     */
    @GetMapping("/detail")
    Result<ApiProductPlanAdditionalInfoDto> detail(@NotBlank(message = "附加险信息表唯一业务ID不能为空") @RequestParam(value = "additionalBizId") String additionalBizId);

    /**
     * 删除单个附加险信息
     * @param additionalBizId
     * @return
     */
    @DeleteMapping("/del")
    Result del(@NotBlank(message = "附加险信息表唯一业务ID不能为空") @RequestParam(value = "additionalBizId") String additionalBizId);
}
