package com.yd.csf.service.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yd.common.enums.ResultCode;
import com.yd.common.exception.BusinessException;
import com.yd.csf.service.dto.PolicySecondHolderUpdateRequest;
import com.yd.csf.service.model.PolicySecondHolder;
import com.yd.csf.service.service.PolicySecondHolderService;
import com.yd.csf.service.dao.PolicySecondHolderMapper;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

import java.util.Date;

/**
* @author Zhang Jianan
* @description 针对表【policy_second_holder(第二持有人信息表)】的数据库操作Service实现
* @createDate 2025-10-31 13:29:23
*/
@Service
public class PolicySecondHolderServiceImpl extends ServiceImpl<PolicySecondHolderMapper, PolicySecondHolder>
    implements PolicySecondHolderService{

    @Override
    public Boolean updatePolicySecondHolder(PolicySecondHolderUpdateRequest policySecondHolderUpdateRequest) {
        if (policySecondHolderUpdateRequest == null || StringUtils.isBlank(policySecondHolderUpdateRequest.getPolicySecondHolderBizId())) {
            throw new BusinessException(ResultCode.PARAMS_ERROR.getCode(), "policySecondHolderBizId不能为空");
        }
        PolicySecondHolder policySecondHolder = this.getOne(new QueryWrapper<PolicySecondHolder>().eq("policy_second_holder_biz_id", policySecondHolderUpdateRequest.getPolicySecondHolderBizId()));
        if (policySecondHolder == null) {
            throw new BusinessException(ResultCode.NULL_ERROR.getCode(), ResultCode.NULL_ERROR.getMessage());
        }
        BeanUtils.copyProperties(policySecondHolderUpdateRequest, policySecondHolder, "policyBizId", "policySecondHolderBizId", "id");
        policySecondHolder.setUpdateTime(new Date());
        return this.updateById(policySecondHolder);
    }
}




