package com.yd.csf.service.dao;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yd.csf.service.model.CommissionExpected;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.yd.csf.service.vo.CommissionExpectedStatisticsVO;
import com.yd.csf.service.vo.ReceivableReportVO;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
* @author Zhang Jianan
* @description 针对表【commission_expected(预计来佣表)】的数据库操作Mapper
* @createDate 2025-10-08 19:47:40
* @Entity generator.domain.CommissionExpected
*/
public interface CommissionExpectedMapper extends BaseMapper<CommissionExpected> {

    CommissionExpectedStatisticsVO getExpectedStatistics(@Param("expectedIds")List<Long> expectedIds);

    /**
     * 应收款报表 - 按保单号和期数维度统计（分页）
     * @param page 分页参数
     * @param expectedIds 预计来佣ID列表
     * @return 应收款报表VO分页列表
     */
    IPage<ReceivableReportVO> receivableReportPage(@Param("page") Page<ReceivableReportVO> page,
                                                    @Param("expectedIds") List<Long> expectedIds);
}




