package com.yd.csf.service.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yd.common.enums.ResultCode;
import com.yd.common.exception.BusinessException;
import com.yd.csf.service.dto.PolicyPolicyholderUpdateRequest;
import com.yd.csf.service.model.PolicyPolicyholder;
import com.yd.csf.service.service.PolicyPolicyholderService;
import com.yd.csf.service.dao.PolicyPolicyholderMapper;
import com.yd.csf.service.utils.GSONUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

import java.util.Date;

/**
* @author Zhang Jianan
* @description 针对表【policy_policyholder(保单投保人信息表)】的数据库操作Service实现
* @createDate 2025-10-31 11:43:10
*/
@Service
public class PolicyPolicyholderServiceImpl extends ServiceImpl<PolicyPolicyholderMapper, PolicyPolicyholder>
    implements PolicyPolicyholderService{

    @Override
    public boolean update(PolicyPolicyholderUpdateRequest policyPolicyholderUpdateRequest) {
        if (policyPolicyholderUpdateRequest == null || policyPolicyholderUpdateRequest.getPolicyPolicyholderBizId() == null) {
            throw new BusinessException(ResultCode.PARAMS_ERROR.getCode(), ResultCode.PARAMS_ERROR.getMessage());
        }
        PolicyPolicyholder policyPolicyholder = this.getOne(new QueryWrapper<PolicyPolicyholder>().eq("policy_policyholder_biz_id", policyPolicyholderUpdateRequest.getPolicyPolicyholderBizId()));
        if (policyPolicyholder == null) {
            throw new BusinessException(ResultCode.NULL_ERROR.getCode(), ResultCode.NULL_ERROR.getMessage());
        }
        BeanUtils.copyProperties(policyPolicyholderUpdateRequest, policyPolicyholder, "policyBizId", "policyPolicyholderBizId", "id");
        // 处理地址Json
        if (CollectionUtils.isNotEmpty(policyPolicyholderUpdateRequest.getAddressList())) {
            policyPolicyholder.setAddressList(GSONUtil.toJson(policyPolicyholderUpdateRequest.getAddressList()));
        }
        policyPolicyholder.setUpdateTime(new Date());
        return this.updateById(policyPolicyholder);
    }
}




