package com.yd.csf.service.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.yd.csf.service.model.FortuneAccount;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import org.springframework.beans.BeanUtils;

import java.util.Date;
import java.util.List;
import java.util.Map;

@Data
public class FortuneAccountVO {
    /**
     * 出账记录业务id
     */
    @Schema(description = "出账记录业务id")
    private String fortuneAccountBizId;

    /**
     * 转介人
     */
    @Schema(description = "转介人")
    private String broker;

    /**
     * 出账日期
     */
    @Schema(description = "出账日期")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date fortuneAccountDate;

    /**
     * 出账信息
     */
    @Schema(description = "出账信息")
    private List<Map<String, Object>> fortuneList;

    /**
     * 备注
     */
    @Schema(description = "备注")
    private String remark;


    /**
     * 对象转封装类
     *
     * @param fortuneAccount
     * @return
     */
    public static FortuneAccountVO objToVo(FortuneAccount fortuneAccount) {
        if (fortuneAccount == null) {
            return null;
        }
        FortuneAccountVO fortuneAccountVO = new FortuneAccountVO();
        BeanUtils.copyProperties(fortuneAccount, fortuneAccountVO);

        return fortuneAccountVO;
    }
}
