package com.yd.csf.service.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 邮寄信息保存请求
 */
@Data
public class MailingInfoSaveRequest implements Serializable {

    private static final long serialVersionUID = 1L;

    @Schema(description = "新单跟进唯一业务ID", requiredMode = Schema.RequiredMode.REQUIRED)
    private String policyBizId;

    @Schema(description = "寄送方式（字典值：1-自提 2-快递）")
    private String mailingMethod;

    @Schema(description = "快递单号")
    private String deliveryNo;

    @Schema(description = "经纪公司签收日期", format = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date brokerSignDate;

    @Schema(description = "客户签收日期", format = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date customerSignDate;
}
