package com.yd.csf.service.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import lombok.Getter;
import lombok.Setter;

/**
 * <p>
 * 保费对账记录表
 * </p>
 *
 * @author zxm
 * @since 2025-12-26
 */
@Getter
@Setter
@TableName("premium_reconciliation")
public class PremiumReconciliation implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键ID
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 保费对账记录表唯一业务ID
     */
    @TableField("premium_reconciliation_biz_id")
    private String premiumReconciliationBizId;

    /**
     * 对账类型
     */
    @TableField("reconciliation_type")
    private String reconciliationType;

    /**
     * 当前期数
     */
    @TableField("current_issue_number")
    private String currentIssueNumber;

    /**
     * 申请人
     */
    @TableField("applicant")
    private String applicant;

    /**
     * 保单号
     */
    @TableField("policy_no")
    private String policyNo;

    /**
     * 保单受保人（被保人）
     */
    @TableField("insured")
    private String insured;

    /**
     * 保险公司
     */
    @TableField("insurance_company")
    private String insuranceCompany;

    /**
     * 保险公司业务id
     */
    @TableField("insurance_company_biz_id")
    private String insuranceCompanyBizId;

    /**
     * 当次保司认定金额（客户当次缴纳的金额）
     */
    @TableField("recognized_amount")
    private BigDecimal recognizedAmount;

    /**
     * 当次保司认定币种
     */
    @TableField("recognized_currency")
    private String recognizedCurrency;

    /**
     * 当期剩余待付金额
     */
    @TableField("remaining_unpaid_amount")
    private BigDecimal remainingUnpaidAmount;

    /**
     * 当期剩余待付币种
     */
    @TableField("remaining_unpaid_currency")
    private String remainingUnpaidCurrency;

    /**
     * 对账状态
     */
    @TableField("reconciliation_status")
    private String reconciliationStatus;

    /**
     * 通用备注
     */
    @TableField("remark")
    private String remark;

    /**
     * 删除标识: 0-正常, 1-删除
     */
    @TableField("is_deleted")
    private Integer isDeleted;

    /**
     * 创建人ID
     */
    @TableField("creator_id")
    private String creatorId;

    /**
     * 更新人ID
     */
    @TableField("updater_id")
    private String updaterId;

    /**
     * 创建时间
     */
    @TableField("create_time")
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    @TableField("update_time")
    private LocalDateTime updateTime;

}
