package com.yd.csf.service.service;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yd.csf.service.dto.CustomerAddRequest;
import com.yd.csf.service.dto.CustomerQueryRequest;
import com.yd.csf.service.dto.CustomerUpdateRequest;
import com.yd.csf.service.dto.FnaQueryRequest;
import com.yd.csf.service.model.Customer;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yd.csf.service.model.CustomerExpand;
import com.yd.csf.service.vo.CustomerVO;
import com.yd.csf.service.vo.FnaVO;

import java.util.Map;


/**
* @author Zhang Jianan
* @description 针对表【customer(客户信息表)】的数据库操作Service
* @createDate 2025-08-29 17:38:23
*/
public interface CustomerService extends IService<Customer> {

    CustomerVO getCustomerVO(Customer customer);

    Wrapper<Customer> getQueryWrapper(CustomerQueryRequest customerQueryRequest);

    CustomerExpand getCustomerExpand(CustomerAddRequest customerAddRequest);

    Page<CustomerVO> getCustomerVOPage(Page<Customer> customerPage);

    Customer getByCustomerBizId(String customerBizId);

    Map<String, Object> addCustomer(CustomerAddRequest customerAddRequest);

    void validCustomer(Customer customer);

    Boolean updateCustomer(CustomerUpdateRequest customerUpdateRequest);

    void queryDependentsNum(Customer customer);
}
