package com.yd.csf.feign.client.expectedfortune;

import com.yd.common.result.Result;
import com.yd.csf.feign.fallback.expectedfortune.ApiExpectedFortuneFeignFallbackFactory;
import com.yd.csf.feign.request.expectedfortune.ApiGenerateExpectedFortuneRequest;
import com.yd.csf.feign.request.expectedfortune.ApiExpectedFortunePageRequest;
import com.yd.csf.feign.response.expectedfortune.ApiGenerateExpectedFortuneResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import javax.validation.constraints.NotBlank;

/**
 * 香港保险服务-预计发佣信息Feign客户端
 */
@FeignClient(name = "yd-csf-api", fallbackFactory = ApiExpectedFortuneFeignFallbackFactory.class)
public interface ApiExpectedFortuneFeignClient {

    /**
     * 生成预计发佣
     * @param request
     * @return
     */
    @PostMapping("/generate")
    Result<ApiGenerateExpectedFortuneResponse> generate(@Validated @RequestBody ApiGenerateExpectedFortuneRequest request);

    /**
     * 分页查询 - 预计发佣
     * @param request
     * @return
     */
    @PostMapping("/page")
    Result page(@RequestBody ApiExpectedFortunePageRequest request);

    /**
     * 查询保单是否生成过预计发佣
     * @param policyNo
     * @return
     */
    @GetMapping("/isGenerate")
    Result<Boolean> isGenerate(@NotBlank(message = "保单号不能为空") @RequestParam(value = "policyNo") String policyNo);
}
