package com.yd.csf.feign.response.common;

import lombok.Data;

import javax.validation.constraints.NotNull;
import java.util.List;

@Data
public class ApiCsfCalculateResponse {

    /**
     * 计算类型 1-通过中文自动加载全部大写的拼音 2-身份证号码计算性别 3-身份证号码计算生日 4-生日计算年龄 5-身高和体重计算BMI指数 6-身份证号码计算性别/生日/年龄
     */
    @NotNull(message = "计算类型不能为空")
    private Integer calculateType;

    /**
     * 计算请求值（单个请求参数值）
     */
    private String requestValue;

    /**
     * 计算请求值列表（多个请求参数值）
     */
    private List<String> requestValueList;

    /**
     * 计算返回值
     */
    private String responseValue;
}
