package com.yd.csf.service.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import lombok.Getter;
import lombok.Setter;

/**
 * <p>
 * 投保人信息表
 * </p>
 *
 * @author zxm
 * @since 2025-12-18
 */
@Getter
@Setter
@TableName("policyholder")
public class Policyholder implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 预约信息主表唯一业务ID
     */
    @TableField("appointment_biz_id")
    private String appointmentBizId;

    /**
     * 投保人信息表唯一业务ID
     */
    @TableField("policyholder_biz_id")
    private String policyholderBizId;

    /**
     * 关联客户信息表唯一业务ID（冗余字段）
     */
    @TableField("customer_biz_id")
    private String customerBizId;

    /**
     * 关联客户编号（和客户信息表唯一业务ID是一对，唯一，冗余字段）
     */
    @TableField("customer_no")
    private String customerNo;

    /**
     * 姓名-中文
     */
    @TableField("name_cn")
    private String nameCn;

    /**
     * 姓名-（拼音/英文，通过中文自动加载全部大写的拼音）
     */
    @TableField("name_py_en")
    private String namePyEn;

    /**
     * 证件类型（字典，下拉选择）
     */
    @TableField("document_type")
    private String documentType;

    /**
     * 证件号码
     */
    @TableField("id_number")
    private String idNumber;

    /**
     * 性别（字典，如果是身份证，自动获取性别和生日）
     */
    @TableField("gender")
    private String gender;

    /**
     * 出生日期（生日，如果是身份证，自动获取性别和生日）
     */
    @TableField("birthday")
    private LocalDateTime birthday;

    /**
     * 年龄（通过生日自动获取年龄）
     */
    @TableField("age")
    private String age;

    /**
     * 国籍（下拉选择）
     */
    @TableField("nationality")
    private String nationality;

    /**
     * 出生地
     */
    @TableField("birthplace")
    private String birthplace;

    /**
     * 是否拥有其他国家公民身份（如美国、日本等）: 0-否, 1-是（字典）
     */
    @TableField("is_other_country")
    private String isOtherCountry;

    /**
     * 吸烟情况（字典）
     */
    @TableField("smoking_status")
    private String smokingStatus;

    /**
     * 婚姻情况（字典）
     */
    @TableField("marital_status")
    private String maritalStatus;

    /**
     * 教育程度（字典）
     */
    @TableField("education_level")
    private String educationLevel;

    /**
     * 是否退休（字典）
     */
    @TableField("is_retirement")
    private String isRetirement;

    /**
     * 退休年龄（如已退休，再显示）
     */
    @TableField("retirement_age")
    private String retirementAge;

    /**
     * 身高（CM)
     */
    @TableField("height")
    private String height;

    /**
     * 体重（KG)
     */
    @TableField("weight")
    private String weight;

    /**
     * BMI指数（根据身高和体重自动计算）
     */
    @TableField("bmi")
    private String bmi;

    /**
     * 风险偏好（字典，下拉选择）
     */
    @TableField("risk_appetite")
    private String riskAppetite;

    /**
     * 受供养人数目（通过FNA带入）
     */
    @TableField("dependents_num")
    private Integer dependentsNum;

    /**
     * 移动电话区号
     */
    @TableField("mobile_code")
    private String mobileCode;

    /**
     * 移动电话
     */
    @TableField("mobile")
    private String mobile;

    /**
     * 住宅电话区号
     */
    @TableField("residence_mobile_code")
    private String residenceMobileCode;

    /**
     * 住宅电话
     */
    @TableField("residence_mobile")
    private String residenceMobile;

    /**
     * 固定电话区号
     */
    @TableField("landline_code")
    private String landlineCode;

    /**
     * 固定电话
     */
    @TableField("landline")
    private String landline;

    /**
     * 邮箱
     */
    @TableField("email")
    private String email;

    /**
     * 证件地址
     */
    @TableField("certificate_address")
    private String certificateAddress;

    /**
     * 通讯地址
     */
    @TableField("mailing_address")
    private String mailingAddress;

    /**
     * 居住地址（住宅地址）
     */
    @TableField("residential_address")
    private String residentialAddress;

    /**
     * 通讯地址邮政编号
     */
    @TableField("mailing_address_code")
    private String mailingAddressCode;

    /**
     * 就业情况（字典，下拉选择）
     */
    @TableField("employment_status")
    private String employmentStatus;

    /**
     * 公司/学校名称
     */
    @TableField("cs_name")
    private String csName;

    /**
     * 行业
     */
    @TableField("industry")
    private String industry;

    /**
     * 现时每月收入（HKD)
     */
    @TableField("current_monthly_income")
    private BigDecimal currentMonthlyIncome;

    /**
     * 总工作年期
     */
    @TableField("total_working_years")
    private BigDecimal totalWorkingYears;

    /**
     * 受雇于现职年期
     */
    @TableField("current_tenure")
    private BigDecimal currentTenure;

    /**
     * 职位
     */
    @TableField("position")
    private String position;

    /**
     * 公司地址
     */
    @TableField("company_address")
    private String companyAddress;

    /**
     * 公司电话区号
     */
    @TableField("company_mobile_code")
    private String companyMobileCode;

    /**
     * 公司电话
     */
    @TableField("company_mobile")
    private String companyMobile;

    /**
     * 公司地址邮政编号
     */
    @TableField("company_address_code")
    private String companyAddressCode;

    /**
     * 平均每月收入（HKD）
     */
    @TableField("month_income")
    private BigDecimal monthIncome;

    /**
     * 平均每月支出（HKD）
     */
    @TableField("month_expenditure")
    private BigDecimal monthExpenditure;

    /**
     * 总流动资产（HKD）
     */
    @TableField("total_current_assets")
    private BigDecimal totalCurrentAssets;

    /**
     * 总负债额（HKD）
     */
    @TableField("total_debt")
    private BigDecimal totalDebt;

    /**
     * 旅行（字典）
     */
    @TableField("travel")
    private String travel;

    /**
     * 运动（字典，下拉选择）
     */
    @TableField("exercise")
    private String exercise;

    /**
     * 游戏（字典，下拉选择）
     */
    @TableField("game")
    private String game;

    /**
     * 电影/戏剧（字典，下拉选择）
     */
    @TableField("movie_drama")
    private String movieDrama;

    /**
     * 美食（输入）
     */
    @TableField("delicacy")
    private String delicacy;

    /**
     * 地址列表（json串）
     */
    @TableField("address_list")
    private String addressList;

    /**
     * 通用备注
     */
    @TableField("remark")
    private String remark;

    /**
     * 删除标识: 0-正常, 1-删除
     */
    @TableField("is_deleted")
    private Integer isDeleted;

    /**
     * 创建人ID
     */
    @TableField("creator_id")
    private String creatorId;

    /**
     * 更新人ID
     */
    @TableField("updater_id")
    private String updaterId;

    /**
     * 创建时间
     */
    @TableField("create_time")
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    @TableField("update_time")
    private LocalDateTime updateTime;
}
