package com.yd.csf.api.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.yd.common.result.Result;
import com.yd.csf.api.service.ApiPolicyReceiptService;
import com.yd.csf.feign.client.policyreceipt.ApiPolicyReceiptFeignClient;
import com.yd.csf.feign.request.policyreceipt.ApiPolicyReceiptAddRequest;
import com.yd.csf.feign.request.policyreceipt.ApiPolicyReceiptPageRequest;
import com.yd.csf.feign.response.policyreceipt.ApiPolicyReceiptDetailResponse;
import com.yd.csf.feign.response.policyreceipt.ApiPolicyReceiptPageResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 保单回执信息
 *
 * @author zxm
 * @since 2025-12-25
 */
@RestController
@RequestMapping("/policyReceipt")
@Validated
public class ApiPolicyReceiptController implements ApiPolicyReceiptFeignClient {

    @Autowired
    private ApiPolicyReceiptService apiPolicyReceiptService;

    /**
     * 分页列表查询-保单回执信息
     * @param request
     * @return
     */
    @Override
    public Result<IPage<ApiPolicyReceiptPageResponse>> page(ApiPolicyReceiptPageRequest request) {
        return apiPolicyReceiptService.page(request);
    }

    /**
     * 详情-保单回执信息
     * @param policyReceiptBizId 保单回执表唯一业务ID
     * @return
     */
    @Override
    public Result<ApiPolicyReceiptDetailResponse> detail(String policyReceiptBizId) {
        return apiPolicyReceiptService.detail(policyReceiptBizId);
    }

    /**
     * 添加-保单回执信息
     * @param request
     * @return
     */
    @Override
    public Result add(ApiPolicyReceiptAddRequest request) {
        return apiPolicyReceiptService.add(request);
    }

    /**
     * 编辑-回执状态
     * @param policyReceiptBizId 保单回执信息表唯一标识(业务ID)
     * @param receiptStatus 回执状态（CONFIRMED-已确认 UNCONFIRMED-未确认）
     * @return
     */
    @Override
    public Result editReceiptStatus(String policyReceiptBizId, String receiptStatus) {
        return apiPolicyReceiptService.editReceiptStatus(policyReceiptBizId,receiptStatus);
    }


}
