package com.yd.csf.api.controller;

import com.yd.common.result.Result;
import com.yd.csf.api.service.ApiPremiumRemittanceService;
import com.yd.csf.feign.client.premiumremittance.ApiPremiumRemittanceFeignClient;
import com.yd.csf.feign.dto.premiumremittance.ApiPremiumRemittanceDto;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 保费对账-汇款记录信息
 *
 * @author zxm
 * @since 2025-12-26
 */
@RestController
@RequestMapping("/premiumRemittance")
@Validated
public class ApiPremiumRemittanceController implements ApiPremiumRemittanceFeignClient {

    @Autowired
    private ApiPremiumRemittanceService apiPremiumRemittanceService;

    /**
     * 添加-单个保费对账汇款记录信息
     * @param request
     * @return
     */
    @Override
    public Result add(ApiPremiumRemittanceDto request) {
        return apiPremiumRemittanceService.add(request);
    }

    /**
     * 编辑-单个保费对账汇款记录信息
     * @param request
     * @return
     */
    @Override
    public Result edit(ApiPremiumRemittanceDto request) {
        return apiPremiumRemittanceService.edit(request);
    }

    /**
     * 详情-保费对账汇款记录信息
     * @param premiumRemittanceBizId 保费对账-汇款记录表唯一业务ID
     * @return
     */
    @Override
    public Result<ApiPremiumRemittanceDto> detail(String premiumRemittanceBizId) {
        return apiPremiumRemittanceService.detail(premiumRemittanceBizId);
    }

    /**
     * 删除-单个保费对账汇款记录信息
     * @param premiumRemittanceBizId
     * @return
     */
    @Override
    public Result del(String premiumRemittanceBizId) {
        return apiPremiumRemittanceService.del(premiumRemittanceBizId);
    }

}
