package com.yd.csf.feign.fallback.premiumremittance;

import com.yd.common.result.Result;
import com.yd.csf.feign.client.premiumremittance.ApiPremiumRemittanceFeignClient;
import com.yd.csf.feign.dto.premiumremittance.ApiPremiumRemittanceDto;
import lombok.extern.slf4j.Slf4j;
import org.springframework.cloud.openfeign.FallbackFactory;
import org.springframework.stereotype.Component;

import javax.validation.constraints.NotBlank;

/**
 * 香港保险服务-保费汇款记录信息Feign降级处理
 */
@Slf4j
@Component
public class ApiPremiumRemittanceFeignFallbackFactory implements FallbackFactory<ApiPremiumRemittanceFeignClient> {
    @Override
    public ApiPremiumRemittanceFeignClient create(Throwable cause) {
        return new ApiPremiumRemittanceFeignClient() {
            @Override
            public Result add(ApiPremiumRemittanceDto request) {
                return null;
            }

            @Override
            public Result edit(ApiPremiumRemittanceDto request) {
                return null;
            }

            @Override
            public Result<ApiPremiumRemittanceDto> detail(String premiumRemittanceBizId) {
                return null;
            }

            @Override
            public Result del(String premiumRemittanceBizId) {
                return null;
            }
        };
    }
}
