package com.yd.csf.service.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.io.Serializable;

/**
 * 获取保单应收款请求参数
 */
@Data
public class GetExpectedCommissionByProductlaunchIdRequest implements Serializable {
    /**
     * 保单号
     */
    @Schema(description = "保单号", requiredMode = Schema.RequiredMode.REQUIRED)
    private String policyNo;
    /**
     * 产品计划业务id
     */
    @Schema(description = "产品计划业务id", requiredMode = Schema.RequiredMode.REQUIRED)
    private String productLaunchBizId;
    /**
     * 保险公司业务id
     */
    @Schema(description = "保险公司业务id")
    private String insuranceCompanyBizId;
    /**
     * 对账公司
     */
    @Schema(description = "对账公司")
    private String reconciliationCompany;
    /**
     * 对账公司编码
     */
    @Schema(description = "对账公司编码")
    private String reconciliationCompanyCode;
    /**
     * 对账公司业务id
     */
    @Schema(description = "对账公司业务id", requiredMode = Schema.RequiredMode.REQUIRED)
    private String reconciliationCompanyBizId;
}
