package com.yd.csf.service.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.yd.csf.service.model.PolicyBroker;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

@Data
public class PolicyFollowAddRequest implements Serializable {
    /**
     * 保单号
     */
    @Schema(description = "保单号")
    private String policyNo;

    /**
     * 签单日期
     */
    @Schema(description = "签单日期")
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date signDate;

     /**
     * 预约业务id
     */
    @Schema(description = "预约业务id")
    private String appointmentBizId;

    /**
     * 预约单号
     */
    @Schema(description = "预约单号")
    private String appointmentNo;

    /**
     * 签单人
     */
    @Schema(description = "签单人")
    private String signer;

    /**
     * 供款年期
     */
    @Schema(description = "供款年期")
    private Integer paymentTerm;

    /**
     * 是否预缴: 0-否, 1-是
     */
    @Schema(description = "是否预缴: 0-否, 1-是")
    private Integer isPrepaid;

    /**
     * 预缴年期
     */
    @Schema(description = "预缴年期")
    private Integer prepaidTerm;

    /**
     * 产品名称
     */
    @Schema(description = "产品名称")
    private String productName;

     /**
     * 产品类别
     */
    @Schema(description = "产品类别")
    private String productCate;

    /**
     * 保险公司
     */
    @Schema(description = "保险公司")
    private String insurer;

    /**
     * 保险公司业务id
     */
    @Schema(description = "保险公司业务id")
    private String insurerBizId;

    /**
     * 对账公司
     */
    @Schema(description = "对账公司")
    private String reconciliationCompany;

    /**
     * 对账公司业务id
     */
    @Schema(description = "对账公司业务id")
    private String reconciliationCompanyBizId;

    /**
     * 新单跟进状态
     */
    @Schema(description = "新单跟进状态 'CHECKING'-'审核中','UNDERWRITING'-'承保中','FINISHED'-'已完成','DECLINED'-'已拒绝','CANCELLED'-'已取消', 字典值: policy_follow_status")
    private String status;

    /**
     * 保單持有人
     */
    @Schema(description = "保單持有人")
    private String policyHolder;

    /**
     * 受保人
     */
    @Schema(description = "受保人")
    private String insured;

    /**
     * 币种
     */
    @Schema(description = "币种")
    private String currency;

    /**
     * 首期保费（不含徽费，预缴保费）
     */
    @Schema(description = "首期保费（不含徽费，预缴保费）")
    private Object initialPremium;

    /**
     * 转介人
     */
    @Schema(description = "转介人")
    private List<PolicyBroker> brokerList;

     private static final long serialVersionUID = 1L;
}
