package com.yd.csf.service.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yd.csf.feign.request.conditionconfig.ApiConditionConfigPageRequest;
import com.yd.csf.feign.response.conditionconfig.ApiConditionConfigPageResponse;
import com.yd.csf.service.dto.ConditionConfigDto;
import com.yd.csf.service.model.ConditionConfig;
import com.yd.csf.service.dao.ConditionConfigMapper;
import com.yd.csf.service.model.FormulaConfig;
import com.yd.csf.service.service.IConditionConfigService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * <p>
 * 条件配置表 服务实现类
 * </p>
 *
 * @author zxm
 * @since 2025-10-17
 */
@Service
public class ConditionConfigServiceImpl extends ServiceImpl<ConditionConfigMapper, ConditionConfig> implements IConditionConfigService {

    @Override
    public IPage<ApiConditionConfigPageResponse> page(Page<ApiConditionConfigPageResponse> page,
                                                      ApiConditionConfigPageRequest request) {
        return baseMapper.page(page,request);
    }

    /**
     * 查询单个对象
     * @param conditionBizId
     * @return
     */
    @Override
    public ConditionConfig queryOne(String conditionBizId) {
        return this.getOne(new LambdaQueryWrapper<ConditionConfig>().eq(ConditionConfig::getConditionBizId,conditionBizId));
    }

    /**
     * 查询列表
     * @param dto
     * @return
     */
    @Override
    public List<ConditionConfig> queryList(ConditionConfigDto dto) {
        List<ConditionConfig> list = baseMapper.selectList(new LambdaQueryWrapper<ConditionConfig>()
                .eq(StringUtils.isNotBlank(dto.getConditionTypeBizId()),ConditionConfig::getConditionTypeBizId,dto.getConditionTypeBizId())
                .eq(StringUtils.isNotBlank(dto.getConditionBizId()) && !dto.getIsExcludeMy(), ConditionConfig::getConditionBizId,dto.getConditionBizId())
                .eq(StringUtils.isNotBlank(dto.getName()),ConditionConfig::getName,dto.getName())
                .ne(dto.getIsExcludeMy(),ConditionConfig::getConditionBizId,dto.getConditionBizId())
        );
        return list;
    }
}
