package com.yd.csf.feign.client.commissionsqltemplate;

import com.yd.common.result.Result;
import com.yd.csf.feign.fallback.commissionsqltemplate.ApiCommissionSqlTemplateFeignFallbackFactory;
import com.yd.csf.feign.request.commissionsqltemplate.ApiCommissionSqlTemplatePageRequest;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 香港保险服务-SQL模板信息Feign客户端
 */
@FeignClient(name = "yd-csf-api", fallbackFactory = ApiCommissionSqlTemplateFeignFallbackFactory.class)
public interface ApiCommissionSqlTemplateFeignClient {

    /**
     * 分页查询-SQL模板信息
     * @param request
     * @return
     */
    @PostMapping("/page")
    Result page(@RequestBody ApiCommissionSqlTemplatePageRequest request);
}
