package com.yd.csf.service.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import lombok.Data;

/**
 * 受益人信息表
 * @TableName policy_beneficiary
 */
@TableName(value ="policy_beneficiary")
@Data
public class PolicyBeneficiary implements Serializable {
    /**
     * 
     */
    @TableId(type = IdType.AUTO)
    private Long id;

    /**
     * 保单受益人信息表唯一业务ID
     */
    private String policyBeneficiaryBizId;

    /**
     * 新单跟进业务ID
     */
    private String policyBizId;

    /**
     * 保单号
     */
    private String policyNo;

    /**
     * 客户类型（字典）(个人或者公司)
     */
    private String customerType;

    /**
     * 与受保人关系（字典）
     */
    private String insurantRel;

    /**
     * 受益比例
     */
    private BigDecimal benefitRatio;

    /**
     * 名字
     */
    private String name;

    /**
     * 名字-英文
     */
    private String nameEn;

    /**
     * 性别（字典）
     */
    private String gender;

    /**
     * 证件类型（字典）
     */
    private String documentType;

    /**
     * 证件号码
     */
    private String idNumber;

    /**
     * 护照号码
     */
    private String passportNumber;

    /**
     * 出生日期
     */
    private Date birthTime;

    /**
     * 公司名称
     */
    private String companyName;

    /**
     * 公司名称（英文）
     */
    private String companyNameEn;

    /**
     * 公司商业登记号码
     */
    private String companyBusinessNo;

    /**
     * 公司注册日期
     */
    private Date companyRegisterTime;

    /**
     * 公司注册地区（字典）
     */
    private String companyRegisterRegion;

    /**
     * 公司电话区号
     */
    private String companyMobileCode;

    /**
     * 公司电话
     */
    private String companyMobile;

    /**
     * 公司邮箱
     */
    private String companyEmail;

    /**
     * 公司登记地址
     */
    private String companyEnterAddress;

    /**
     * 通讯地址
     */
    private String mailingAddress;

    /**
     * 授权代表姓名中文-名字
     */
    private String authNameCn;

    /**
     * 授权代表姓名英文-名字
     */
    private String authNameEn;

    /**
     * 授权代表职称
     */
    private String authProfessional;

    /**
     * 授权代表电话区号
     */
    private String authMobileCode;

    /**
     * 授权代表电话
     */
    private String authMobile;

    /**
     * 地址列表（json串）
     */
    private Object addressList;

    /**
     * 通用备注
     */
    private String remark;

    /**
     * 删除标识: 0-正常, 1-删除
     */
    private Integer isDeleted;

    /**
     * 创建人ID
     */
    private String creatorId;

    /**
     * 更新人ID
     */
    private String updaterId;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 更新时间
     */
    private Date updateTime;

    @TableField(exist = false)
    private static final long serialVersionUID = 1L;
}