package com.yd.csf.feign.fallback.formulaconfig;

import com.yd.common.result.Result;
import com.yd.csf.feign.client.formulaconfig.ApiFormulaConfigFeignClient;
import com.yd.csf.feign.request.formulaconfig.ApiFormulaConfigAddRequest;
import com.yd.csf.feign.request.formulaconfig.ApiFormulaConfigEditRequest;
import com.yd.csf.feign.request.formulaconfig.ApiFormulaConfigPageRequest;
import com.yd.csf.feign.response.formulaconfig.ApiFormulaConfigDetailResponse;
import lombok.extern.slf4j.Slf4j;
import org.springframework.cloud.openfeign.FallbackFactory;
import org.springframework.stereotype.Component;

import javax.validation.constraints.NotBlank;

/**
 * 香港保险服务-公式配置信息Feign降级处理
 */
@Slf4j
@Component
public class ApiFormulaConfigFeignFallbackFactory implements FallbackFactory<ApiFormulaConfigFeignClient> {

    @Override
    public ApiFormulaConfigFeignClient create(Throwable cause) {
        return new ApiFormulaConfigFeignClient() {
            @Override
            public Result page(ApiFormulaConfigPageRequest request) {
                return null;
            }

            @Override
            public Result<ApiFormulaConfigDetailResponse> detail(String formulaBizId) {
                return null;
            }

            @Override
            public Result add(ApiFormulaConfigAddRequest request) {
                return null;
            }

            @Override
            public Result edit(ApiFormulaConfigEditRequest request) {
                return null;
            }

            @Override
            public Result del(String formulaBizId) {
                return null;
            }
        };
    }
}
