package com.yd.csf.service.service.impl;

import cn.hutool.core.collection.CollUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.google.gson.Gson;
import com.yd.csf.service.dao.CustomerMapper;
import com.yd.csf.service.dto.CustomerAddRequest;
import com.yd.csf.service.dto.CustomerQueryRequest;
import com.yd.csf.service.dto.FnaQueryRequest;
import com.yd.csf.service.model.Customer;
import com.yd.csf.service.model.CustomerExpand;
import com.yd.csf.service.service.CustomerExpandService;
import com.yd.csf.service.service.CustomerService;
import com.yd.csf.service.vo.AddressVO;
import com.yd.csf.service.vo.CustomerExpandVO;
import com.yd.csf.service.vo.CustomerVO;
import com.yd.csf.service.vo.FnaVO;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

/**
* @author Zhang Jianan
* @description 针对表【customer(客户信息表)】的数据库操作Service实现
* @createDate 2025-08-29 17:38:23
*/
@Service
public class CustomerServiceImpl extends ServiceImpl<CustomerMapper, Customer>
    implements CustomerService{

    private final static Gson GSON = new Gson();

    @Resource
    private CustomerExpandService customerExpandService;

    @Override
    public CustomerVO getCustomerVO(Customer customer) {
        return CustomerVO.objToVo(customer);
    }

    @Override
    public Wrapper<Customer> getQueryWrapper(CustomerQueryRequest customerQueryRequest) {
        return null;
    }

    @Override
    public CustomerExpand getCustomerExpand(CustomerAddRequest customerAddRequest) {
        CustomerExpand customerExpand = new CustomerExpand();
        BeanUtils.copyProperties(customerAddRequest, customerExpand);
        AddressVO residenceAddress = customerAddRequest.getResidenceAddress();
        if (residenceAddress != null) {
            customerExpand.setResidenceAddress(GSON.toJson(residenceAddress));
        }
        AddressVO residentialAddress = customerAddRequest.getResidentialAddress();
        if (residentialAddress != null) {
            customerExpand.setResidentialAddress(GSON.toJson(residentialAddress));
        }
        AddressVO mailingAddress = customerAddRequest.getMailingAddress();
        if (mailingAddress != null) {
            customerExpand.setMailingAddress(GSON.toJson(mailingAddress));
        }
        AddressVO companyAddress = customerAddRequest.getCompanyAddress();
        if (companyAddress != null) {
            customerExpand.setCompanyAddress(GSON.toJson(companyAddress));
        }
        return customerExpand;
    }

    @Override
    public Page<CustomerVO> getCustomerVOPage(Page<Customer> customerPage) {
        List<Customer> customerList = customerPage.getRecords();
        Page<CustomerVO> customerVOPage = new Page<>(customerPage.getCurrent(), customerPage.getSize(), customerPage.getTotal());
        if (CollUtil.isEmpty(customerList)) {
            return customerVOPage;
        }
        // 对象列表 => 封装对象列表
        List<CustomerVO> customerVOList = customerList.stream().map(CustomerVO::objToVo).collect(Collectors.toList());

        // 1. 关联查询扩展信息
        Set<String> customerIdSet = customerList.stream().map(Customer::getCustomerBizId).collect(Collectors.toSet());
        Map<String, List<CustomerExpand>> customerBizIdCustomerExpandListMap = customerExpandService.listByIds(customerIdSet).stream()
                .collect(Collectors.groupingBy(CustomerExpand::getCustomerBizId));

        // 填充信息
        customerVOList.forEach(customerVO -> {
            String customerBizId = customerVO.getCustomerBizId();
            CustomerExpand customerExpand = null;
            if (customerBizIdCustomerExpandListMap.containsKey(customerBizId)) {
                customerExpand = customerBizIdCustomerExpandListMap.get(customerBizId).get(0);
            }
            customerVO.setCustomerExpand(CustomerExpandVO.objToVo(customerExpand));
        });
        // endregion

        customerVOPage.setRecords(customerVOList);
        return customerVOPage;
    }

    @Override
    public Customer getByCustomerBizId(String customerBizId) {
        return baseMapper.selectOne(new LambdaQueryWrapper<Customer>().eq(Customer::getCustomerBizId, customerBizId));
    }

}




