package com.yd.csf.service.vo;

import com.yd.csf.service.model.CustomerExpand;
import lombok.Data;
import org.springframework.beans.BeanUtils;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 客户扩展信息视图
 *
 */
@Data
public class CustomerExpandVO implements Serializable {

    /**
     * 客户扩展信息唯一业务ID
     */
    private String customerExpandBizId;

    /**
     * 客户信息唯一标识(业务ID)
     */
    private String customerBizId;

    /**
     * 客户类型
     */
    private Object customerType;

    /**
     * 居住地区代码
     */
    private String residenceAreaCode;

    /**
     * 住宅电话
     */
    private String residenceTelephone;

    /**
     * 是否长期出国
     */
    private String longtimeAbroad;

    /**
     * 居住地址
     */
    private Object residenceAddress;

    /**
     * 住宅地址
     */
    private Object residentialAddress;

    /**
     * 邮寄地址
     */
    private Object mailingAddress;

    /**
     * 公司地址
     */
    private Object companyAddress;

    /**
     * 公司名称
     */
    private String companyName;

    /**
     * 公司地区代码
     */
    private String companyAreaCode;

    /**
     * 公司电话
     */
    private String companyTelephone;

    /**
     * 职位
     */
    private String position;

    /**
     * 工作年限
     */
    private String workYear;

    /**
     * 薪资
     */
    private BigDecimal salary;

    /**
     * 通用备注
     */
    private String remark;


    /**
     * 封装类转对象
     *
     * @param customerExpandVO
     * @return
     */
    public static CustomerExpand voToObj(CustomerExpandVO customerExpandVO) {
        if (customerExpandVO == null) {
            return null;
        }
        CustomerExpand customerExpand = new CustomerExpand();
        BeanUtils.copyProperties(customerExpandVO, customerExpand);

        return customerExpand;
    }

    /**
     * 对象转封装类
     *
     * @param customerExpand
     * @return
     */
    public static CustomerExpandVO objToVo(CustomerExpand customerExpand) {
        if (customerExpand == null) {
            return null;
        }
        CustomerExpandVO customerExpandVO = new CustomerExpandVO();
        BeanUtils.copyProperties(customerExpand, customerExpandVO);

        return customerExpandVO;
    }
}
