package com.yd.csf.service.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

import com.yd.csf.service.vo.FnaVO;
import lombok.Data;
import org.springframework.beans.BeanUtils;

/**
 * 预计来佣表
 *
 * @TableName commission_expected
 */
@TableName(value = "commission_expected")
@Data
public class CommissionExpected implements Serializable {
    /**
     * serial id
     */
    @TableId(type = IdType.AUTO)
    private Long id;

    /**
     * 预计来佣业务id
     */
    private String commissionExpectedBizId;

    /**
     * 应收账款编号
     */
    private String receivableNo;

    /**
     * 应收款类型 R=关联保单应收单 U=非关联保单应收单
     */
    private String commissionBizType;

    /**
     * 保单号
     */
    private String policyNo;

    /**
     * 保险公司业务id
     */
    private String insuranceCompanyBizId;

    /**
     * 产品计划 id
     */
    private String productLaunchBizId;

    /**
     * 对账公司
     */
    private String reconciliationCompany;

    /**
     * 对账公司编码
     */
    private String reconciliationCompanyCode;

    /**
     * 对账公司业务id
     */
    private String reconciliationCompanyBizId;

    /**
     * 佣金期数(1=第一年; 2=第二年; 3=第三年; 4=第四年; 5=第五年)
     */
    private Integer commissionPeriod;

    /**
     * 总来佣期数
     */
    private Integer totalPeriod;

    /**
     * 入账项目(1:销售拥金;2:销售奖金;3:销售津贴;4:续期佣金;5:服务津贴;等等)
     */
    private String commissionName;

    /**
     * 入账项目类型(1:销售拥金;2:销售奖金;3:销售津贴;4:续期佣金;5:服务津贴;等等)
     */
    private String commissionType;

    /**
     * 来佣比例 (%)
     */
    private BigDecimal commissionRatio;

    /**
     * 入账金额
     */
    private BigDecimal amount;

    /**
     * 入账币种
     */
    private String currency;

    /**
     * 来佣日期 (估)
     */
    private Date commissionDate;

    /**
     * 入账日 (实)
     */
    private Date actualCommissionDate;

    /**
     * 入账状态 0=待入账 1=完成入账 2=部分入账 3=已失效 字典值: csf_expected_commission_status
     */
    private String status;

    /**
     * 设置入账状态-修改理由
     */
    private String statusDesc;

    /**
     * 默认结算汇率
     */
    private BigDecimal defaultExchangeRate;

    /**
     * 预计来佣金额，单位：港币
     */
    private BigDecimal expectedAmount;

    /**
     * 已入账来佣金额
     */
    private BigDecimal paidAmount;

    /**
     * 已入账来佣比例
     */
    private BigDecimal paidRatio;

    /**
     * 通用备注
     */
    private String remark;

    /**
     * 删除标识: 0-正常, 1-删除
     */
    private Integer isDeleted;

    /**
     * 创建人ID
     */
    private String creatorId;

    /**
     * 更新人ID
     */
    private String updaterId;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 更新时间
     */
    private Date updateTime;

    @TableField(exist = false)
    private static final long serialVersionUID = 1L;
}