package com.yd.csf.service.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.Data;

import java.io.Serializable;

/**
 * 创建fna请求
 *
 */
@Data
@Tag(name = "创建fna请求")
public class FnaAddRequest implements Serializable {

    /**
     * 租户编码
     */
    @Schema(description = "租户编码", requiredMode = Schema.RequiredMode.REQUIRED)
    private String tenantCode;

    /**
     * 系统用户唯一业务ID
     */
    @Schema(description = "系统用户唯一业务ID")
    private String userBizId;

    /**
     * 客户唯一业务ID
     */
    @Schema(description = "客户唯一业务ID")
    private String customerBizId;

    /**
     * Fna表单唯一业务ID
     */
    @Schema(description = "Fna表单唯一业务ID")
    private String fnaFormBizId;

    /**
     * 预约编号
     */
    @Schema(description = "预约编号")
    private String appointmentNo;

    /**
     * 预约信息主表唯一业务ID
     */
    @Schema(description = "预约信息主表唯一业务ID")
    private String appointmentBizId;

    /**
     * 核保编号
     */
    @Schema(description = "核保编号")
    private String underwritingNo;

    /**
     * 新单跟进ID
     */
    @Schema(description = "新单跟进ID")
    private String policyBizId;

    /**
     * 保单编号
     */
    @Schema(description = "保单编号")
    private String policyNo;

    /**
     * 产品代码
     */
    @Schema(description = "产品代码")
    private String productCode;

    /**
     * 产品名称
     */
    @Schema(description = "产品名称")
    private String productName;

    /**
     * 相关URL
     */
    @Schema(description = "相关URL")
    private String url;

    /**
     * 通用备注
     */
    @Schema(description = "通用备注")
    private String remark;


    private static final long serialVersionUID = 1L;
}