package com.yd.csf.service.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

@Data
public class FortuneAccountAddRequest implements Serializable {
    /**
     * 转介人
     */
    @Schema(description = "转介人", requiredMode = Schema.RequiredMode.REQUIRED)
    private String broker;

    /**
     * 转介人业务ID
     */
    @Schema(description = "转介人业务ID", requiredMode = Schema.RequiredMode.REQUIRED)
    private String brokerBizId;

    /**
     * 所属团队
     */
    @Schema(description = "所属团队", requiredMode = Schema.RequiredMode.REQUIRED)
    private String team;

    /**
     * 所属团队业务ID
     */
    @Schema(description = "所属团队业务ID", requiredMode = Schema.RequiredMode.REQUIRED)
    private String teamBizId;

    /**
     * 出账币种
     */
    @Schema(description = "出账币种", requiredMode = Schema.RequiredMode.REQUIRED)
    private String currency;

    /**
     * 出账总额
     */
    @Schema(description = "出账总额", requiredMode = Schema.RequiredMode.REQUIRED)
    private BigDecimal amount;

    /**
     * 出账状态 1-可出账、2-已出账
     */
    @Schema(description = "出账状态 1-可出账、2-已出账 字典值:csf_fortune_account_status", requiredMode = Schema.RequiredMode.REQUIRED)
    private String status;

    /**
     * 完成出账日期
     */
    @Schema(description = "完成出账日期", requiredMode = Schema.RequiredMode.REQUIRED, example = "2025-09-19", format = "date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date fortuneAccountDate;

    /**
     * 备注
     */
    @Schema(description = "备注")
    private String remark;

    private static final long serialVersionUID = 1L;
}
