package com.yd.csf.service.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yd.csf.feign.request.variable.ApiVariablePageRequest;
import com.yd.csf.feign.response.variable.ApiVariablePageResponse;
import com.yd.csf.service.dto.VariableDto;
import com.yd.csf.service.model.CommissionRuleConfig;
import com.yd.csf.service.model.Variable;
import com.yd.csf.service.dao.VariableMapper;
import com.yd.csf.service.service.IVariableService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * <p>
 * 变量表 服务实现类
 * </p>
 *
 * @author zxm
 * @since 2025-10-16
 */
@Service
public class VariableServiceImpl extends ServiceImpl<VariableMapper, Variable> implements IVariableService {

    @Override
    public IPage<ApiVariablePageResponse> page(Page<ApiVariablePageResponse> page,
                                               ApiVariablePageRequest request) {
        return baseMapper.page(page,request);
    }

    /**
     * 查询单个对象
     * @param variableBizId
     * @return
     */
    @Override
    public Variable queryOne(String variableBizId) {
        return this.getOne(new LambdaQueryWrapper<Variable>().eq(Variable::getVariableBizId,variableBizId));
    }

    /**
     * 查询列表
     * @param dto
     * @return
     */
    @Override
    public List<Variable> queryList(VariableDto dto) {
        List<Variable> list = baseMapper.selectList(new LambdaQueryWrapper<Variable>()
                .eq(StringUtils.isNotBlank(dto.getVariableBizId()) && !dto.getIsExcludeMy(),Variable::getVariableBizId,dto.getVariableBizId())
                .eq(StringUtils.isNotBlank(dto.getNameCn()),Variable::getNameCn,dto.getNameCn())
                .eq(StringUtils.isNotBlank(dto.getNameEn()),Variable::getNameEn,dto.getNameEn())
                .ne(dto.getIsExcludeMy(),Variable::getVariableBizId,dto.getVariableBizId())
        );
        return list;
    }

}
