package com.yd.csf.service.vo;

import cn.hutool.core.convert.Convert;
import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.format.DateTimeFormat;
import com.alibaba.excel.annotation.write.style.ColumnWidth;
import com.alibaba.excel.annotation.write.style.ContentRowHeight;
import com.alibaba.excel.annotation.write.style.HeadRowHeight;
import com.yd.csf.service.enums.FortuneStatusEnum;
import com.yd.csf.service.model.ExpectedFortune;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Date;

@Data
@ContentRowHeight(15)
@HeadRowHeight(20)
@ColumnWidth(20)
public class ExpectedFortuneExportDTO {

    @ExcelProperty("预计发佣业务ID")
    private String expectedFortuneBizId;

    @ExcelProperty("应付款编号")
    private String payableNo;

    @ExcelProperty("应付款类型")
    private String fortuneBizType;

    @ExcelProperty("保单号")
    private String policyNo;

    @ExcelProperty("转介人名称")
    private String broker;

    @ExcelProperty("团队名称")
    private String team;

    @ExcelProperty("出账状态")
    private String status;

    @ExcelProperty("出账币种")
    private String currency;

    @ExcelProperty("出账期数")
    private Integer fortunePeriod;

    @ExcelProperty("出账总期数")
    private Integer fortuneTotalPeriod;

    @ExcelProperty("出账项目")
    private String fortuneName;

    @ExcelProperty("出账日（估）")
    @DateTimeFormat("yyyy-MM-dd")
    @ColumnWidth(25)
    private Date payoutDate;

    @ExcelProperty("出账日（实）")
    @DateTimeFormat("yyyy-MM-dd")
    @ColumnWidth(25)
    private Date actualPayoutDate;

    @ExcelProperty("出账金额（估）")
    private BigDecimal amount;

    @ExcelProperty("已出账比例(%)")
    private BigDecimal paidRatio;

    @ExcelProperty("已出账金额")
    private BigDecimal paidAmount;

    @ExcelProperty("待出账比例(%)")
    private BigDecimal unpaidRatio;

    @ExcelProperty("待出账金额")
    private BigDecimal unpaidAmount;

    @ExcelProperty("持有比例")
    private String brokerRatio;

    @ExcelProperty("保险公司")
    private String insuranceCompany;

    @ExcelProperty("产品计划")
    private String productName;

    @ExcelProperty("期交保费")
    private BigDecimal premium;

    @ExcelProperty("出账状态-修改理由")
    @ColumnWidth(30)
    private String statusDesc;

    @ExcelProperty("备注")
    @ColumnWidth(30)
    private String remark;

    @ExcelProperty("创建时间")
    @DateTimeFormat("yyyy-MM-dd HH:mm:ss")
    @ColumnWidth(25)
    private LocalDateTime createTime;

    @ExcelProperty("更新时间")
    @DateTimeFormat("yyyy-MM-dd HH:mm:ss")
    @ColumnWidth(25)
    private LocalDateTime updateTime;

    /**
     * 将对象转换为导出DTO
     */
    public static ExpectedFortuneExportDTO convertToExportDTO(ExpectedFortune expectedFortune) {
        ExpectedFortuneExportDTO dto = new ExpectedFortuneExportDTO();
        dto.setExpectedFortuneBizId(expectedFortune.getExpectedFortuneBizId());
        dto.setPayableNo(expectedFortune.getPayableNo());
        dto.setFortuneBizType("R".equals(expectedFortune.getFortuneBizType()) ? "关联保单应付款" : "非关联保单应付款");
        dto.setPolicyNo(expectedFortune.getPolicyNo());
        dto.setPremium(expectedFortune.getPremium());
        dto.setFortunePeriod(expectedFortune.getFortunePeriod());
        dto.setFortuneTotalPeriod(expectedFortune.getFortuneTotalPeriod());
        dto.setBroker(expectedFortune.getBroker());
        dto.setTeam(expectedFortune.getTeam());
        dto.setFortuneName(expectedFortune.getFortuneName());
        dto.setBrokerRatio(expectedFortune.getBrokerRatio());
        dto.setAmount(expectedFortune.getAmount());
        dto.setCurrency(expectedFortune.getCurrency());
        dto.setStatus(getStatusText(expectedFortune.getStatus()));
        dto.setStatusDesc(expectedFortune.getStatusDesc());
        dto.setPayoutDate(Convert.toDate(expectedFortune.getPayoutDate()));
        dto.setActualPayoutDate(Convert.toDate(expectedFortune.getActualPayoutDate()));
        dto.setPaidAmount(expectedFortune.getPaidAmount());
        dto.setUnpaidAmount(expectedFortune.getUnpaidAmount());
        dto.setPaidRatio(expectedFortune.getPaidRatio());
        dto.setRemark(expectedFortune.getRemark());
        dto.setCreateTime(expectedFortune.getCreateTime());
        dto.setUpdateTime(expectedFortune.getUpdateTime());
        return dto;
    }

    /**
     * 获取状态文本
     */
    public static String getStatusText(String status) {
        if (status == null) return "未知";
        for (FortuneStatusEnum enumItem : FortuneStatusEnum.values()) {
            if (enumItem.getItemValue().equals(status)) {
                return enumItem.getItemLabel();
            }
        }
        return "未知";
    }
}