package com.yd.csf.api.dto;

import com.baomidou.mybatisplus.annotation.TableField;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

/**
 * 生成业务员（转介人）积分明细表记录入参
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class GenerateAgentDetailFycDto {

    /**
     * 业务员ID（客户端用户表唯一业务ID，转介人业务ID）
     */
    private String agentId;

    /**
     * 积分来源类型：保单转介费、一级管理奖、二级管理奖、辅导津贴奖、终身推荐奖
     */
    private String sourceType;

    /**
     * 积分提供的保单号
     */
    private String policyNo;

    /**
     * 保单发佣批次ID
     */
    private String batchBizId;

    /**
     * 转介人绑定的基本法列表对应计算值
     */
    private List<AlgorithmResDto> algorithmResDtoList;
}
