package com.yd.csf.service.service;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yd.csf.service.dto.*;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yd.csf.service.model.Fna;
import com.yd.csf.service.vo.FnaVO;

import java.util.Map;

/**
* @author Zhang Jianan
* @description 针对表【fna(fna表)】的数据库操作Service
* @createDate 2025-08-29 14:29:15
*/
public interface FnaService extends IService<Fna> {

    Map<String, Object> addFna(FnaAddRequest fnaAddRequest);

    /**
     * 获取查询条件
     *
     * @param fnaQueryRequest
     * @return
     */
    QueryWrapper<Fna> getQueryWrapper(FnaQueryRequest fnaQueryRequest);

    /**
     * 获取fna封装
     *
     * @param fna
     * @return
     */
    FnaVO getFnaVO(Fna fna);

    /**
     * 分页获取fna封装
     *
     * @param fnaPage
     * @return
     */
    Page<FnaVO> getFnaVOPage(Page<Fna> fnaPage);

    Fna getByBizId(String fnaBizId);

    boolean updateByBizId(Fna fna);

    Boolean deleteFna(DeleteFnaRequest deleteRequest);

    Fna queryOne(String fnaBizId);

    Boolean updateFna(FnaUpdateRequest fnaUpdateRequest, String appointmentNo);

    Map<String, Object> copyFna(FnaCopyRequest fnaCopyRequest);

    int updateCustomerNameByCustomerBizId(String firstNamePinyin, String customerBizId);

    /**
     * 根据fnaBizId更新FNA状态
     * @param fnaBizId FNA业务ID
     * @param status 新状态
     * @return 更新行数
     */
    int updateFnaStatus(String fnaBizId, String status);
}
