package com.yd.csf.feign.request.appointment;

import lombok.Data;

import javax.validation.constraints.NotBlank;

/**
 * 预约解除关联计划书
 */
@Data
public class ApiAppointmentRemoveProposalRequest {

    /**
     * 预约信息主表唯一业务ID
     */
    @NotBlank(message = "预约信息主表唯一业务ID不能为空")
    private String appointmentBizId;

    /**
     * 计划书信息表唯一业务ID（冗余字段）
     */
    @NotBlank(message = "计划书信息表唯一业务ID不能为空")
    private String proposalBizId;

    /**
     * 计划书编号（和计划书信息表唯一业务ID是一对，唯一，冗余字段）
     */
    @NotBlank(message = "计划书编号不能为空")
    private String proposalNo;
}
