package com.yd.csf.service.enums;

/**
 * 新单跟进状态枚举 'CHECKING'-'审核中','UNDERWRITING'-'承保中','FINISHED'-'已完成','DECLINED'-'已拒绝','CANCELLED'-'已取消'
 */
public enum PolicyFollowStatusEnum {
    CHECKING("审核中", "CHECKING"),
    UNDERWRITING("承保中", "UNDERWRITING"),
    FINISHED("已完成", "FINISHED"),
    DECLINED("已拒绝", "DECLINED"),
    CANCELLED("已取消", "CANCELLED"),
    ;
    //字典项标签（名称）
    private String itemLabel;
    //字典项值
    private String itemValue;

    //构造函数
    PolicyFollowStatusEnum(String itemLabel, String itemValue) {
        this.itemLabel = itemLabel;
        this.itemValue = itemValue;
    }

    public String getItemLabel() {
        return itemLabel;
    }

    public String getItemValue() {
        return itemValue;
    }
}
