package com.yd.csf.feign.request.appointment;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

@Data
public class ApiAppointmentEditStatusRequest {

    /**
     * 操作类型 1-取消申请 2-取消预约
     */
    @NotNull(message = "操作类型不能为空")
    private Integer oprType;

    /**
     * 预约信息主表唯一业务ID
     */
    @NotBlank(message = "预约信息主表唯一业务ID不能为空")
    private String appointmentBizId;

    /**
     * 预约状态
     */
    @NotNull(message = "预约状态不能为空")
    private Integer status;

    /**
     * 通用备注
     */
    private String remark;
}
