package com.yd.csf.feign.dto.premiumreconciliation;

import lombok.Data;

import javax.validation.constraints.NotBlank;

@Data
public class ApiPremiumReconciliationDto {

    /**
     * 保费对账记录表唯一业务ID
     */
    private String premiumReconciliationBizId;

    /**
     * 对账类型
     */
    @NotBlank(message = "对账类型不能为空")
    private String reconciliationType;

    /**
     * 申请人
     */
    @NotBlank(message = "申请人不能为空")
    private String applicant;

    /**
     * 保单号
     */
    @NotBlank(message = "保单号不能为空")
    private String policyNo;

    /**
     * 保单受保人（被保人）
     */
    @NotBlank(message = "被保人不能为空")
    private String insured;
}
