package com.yd.csf.feign.response.premiumreconciliation;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.math.BigDecimal;
import java.time.LocalDateTime;

@Data
public class ApiPremiumReconciliationPageResponse {

    /**
     * 保费对账记录表唯一业务ID
     */
    private String premiumReconciliationBizId;

    /**
     * 保险公司
     */
    private String insuranceCompany;

    /**
     * 保单号（保单表）
     */
    private String policyNo;

    /**
     * 新单状态（新单跟进表）
     */
    private String policyFollowStatus;

    /**
     * 对账状态（保费对账记录表）
     */
    private String reconciliationStatus;

    /**
     * 保单状态（保单表）
     */
    private String policyStatus;

    /**
     * 当期剩余待付金额（保费对账记录表）
     */
    private BigDecimal remainingUnpaidAmount;

    /**
     * 当期剩余待付币种（保费对账记录表）
     */
    private String remainingUnpaidCurrency;

    /**
     * 付款金额（保费对账-汇款记录表统计合）
     */
    private BigDecimal paymentAmount;

    /**
     * 付款币种（保费对账-汇款记录表）
     */
    private String paymentCurrency;

    /**
     * 缴费方式（保费对账-汇款记录表，多个分号分隔）
     */
    private String paymentMethod;

    /**
     * 当次保司认定金额（客户当次缴纳的金额，保费对账记录表）
     */
    private BigDecimal recognizedAmount;

    /**
     * 当次保司认定币种（保费对账记录表）
     */
    private String recognizedCurrency;

    /**
     * 付款人（保费对账-汇款记录表）
     */
    private String payer;

    /**
     * 付款银行（保费对账-汇款记录表）
     */
    private String payingBank;

    /**
     * 保單持有人（投保人，保单表）
     */
    private String policyHolder;

    /**
     * 受保人（保单表）
     */
    private String insured;

    /**
     * 转介人名称（保单转介人表，多个分号分隔）
     */
    private String brokerName;

    /**
     * 创建时间（保费对账记录表）
     */
    private LocalDateTime createTime;

    /**
     * 更新时间（保费对账记录表）
     */
    private LocalDateTime updateTime;

    /**
     * 对账公司（保单表）
     */
    private String reconciliationCompany;
}
