package com.yd.csf.feign.fallback.secondholder;

import com.yd.common.result.Result;
import com.yd.csf.feign.client.secondholder.ApiSecondHolderFeignClient;
import com.yd.csf.feign.dto.appointment.ApiSecondHolderInfoDto;
import lombok.extern.slf4j.Slf4j;
import org.springframework.cloud.openfeign.FallbackFactory;
import org.springframework.stereotype.Component;

import javax.validation.constraints.NotBlank;

/**
 * 香港保险服务-第二持有人信息Feign降级处理
 */
@Slf4j
@Component
public class ApiSecondHolderFeignFallbackFactory implements FallbackFactory<ApiSecondHolderFeignClient> {

    @Override
    public ApiSecondHolderFeignClient create(Throwable cause) {
        return new ApiSecondHolderFeignClient() {
            @Override
            public Result edit(ApiSecondHolderInfoDto apiSecondHolderInfoDto) {
                return null;
            }

            @Override
            public Result<ApiSecondHolderInfoDto> detail(String appointmentBizId, String secondHolderBizId) {
                return null;
            }

        };
    }
}
