package com.yd.csf.service.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yd.csf.feign.request.expectedfortune.ApiExpectedFortunePageRequest;
import com.yd.csf.feign.response.expectedfortune.ApiExpectedFortunePageResponse;
import com.yd.csf.service.model.ExpectedFortune;
import com.yd.csf.service.dao.ExpectedFortuneMapper;
import com.yd.csf.service.service.IExpectedFortuneService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yd.csf.service.vo.ExpectedFortuneStatisticsVO;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Service;

import java.util.Collections;
import java.util.List;

/**
 * <p>
 * 预计发佣表 服务实现类
 * </p>
 *
 * @author zxm
 * @since 2025-11-17
 */
@Service
public class ExpectedFortuneServiceImpl extends ServiceImpl<ExpectedFortuneMapper, ExpectedFortune> implements IExpectedFortuneService {

    @Override
    public IPage<ApiExpectedFortunePageResponse> page(Page<ApiExpectedFortunePageResponse> page,
                                                      ApiExpectedFortunePageRequest request) {
        return baseMapper.page(page,request);
    }

    @Override
    public List<ExpectedFortune> listByPolicyBizId(String policyBizId) {
        return baseMapper.listByPolicyBizId(policyBizId);
    }

    /**
     * 查询列表
     * @param policyNo
     * @return
     */
    @Override
    public List<ExpectedFortune> queryList(String policyNo) {
        return baseMapper.selectList(new LambdaQueryWrapper<ExpectedFortune>().eq(ExpectedFortune::getPolicyNo,policyNo));
    }

    @Override
    public Boolean batchDelByPolicyNo(String policyNo) {
        return this.remove(new LambdaQueryWrapper<ExpectedFortune>().eq(ExpectedFortune::getPolicyNo,policyNo));
    }

    @Override
    public ExpectedFortuneStatisticsVO getStatistics(List<Long> expectedFortuneIds) {
        return baseMapper.getStatistics(expectedFortuneIds);
    }
}
