package com.yd.csf.service.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yd.common.enums.ResultCode;
import com.yd.common.exception.BusinessException;
import com.yd.common.utils.RandomStringGenerator;
import com.yd.csf.service.dto.PolicyBeneficiaryAddRequest;
import com.yd.csf.service.dto.PolicyBeneficiaryListUpdateRequest;
import com.yd.csf.service.dto.PolicyBeneficiaryUpdateRequest;
import com.yd.csf.service.model.PolicyAdditional;
import com.yd.csf.service.model.PolicyBeneficiary;
import com.yd.csf.service.service.PolicyBeneficiaryService;
import com.yd.csf.service.dao.PolicyBeneficiaryMapper;
import com.yd.csf.service.utils.GSONUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Collections;
import java.util.Date;
import java.util.Map;

/**
* @author Zhang Jianan
* @description 针对表【policy_beneficiary(受益人信息表)】的数据库操作Service实现
* @createDate 2025-10-31 11:43:16
*/
@Service
public class PolicyBeneficiaryServiceImpl extends ServiceImpl<PolicyBeneficiaryMapper, PolicyBeneficiary>
    implements PolicyBeneficiaryService{

    @Override
    public Map<String, Object> addPolicyBeneficiary(PolicyBeneficiaryAddRequest policyBeneficiaryAddRequest) {
        // 校验请求参数
        if (policyBeneficiaryAddRequest == null) {
            throw new BusinessException(ResultCode.PARAMS_ERROR.getCode(), ResultCode.PARAMS_ERROR.getMessage());
        }
        // 转换为实体类
        PolicyBeneficiary policyBeneficiary = new PolicyBeneficiary();
        BeanUtils.copyProperties(policyBeneficiaryAddRequest, policyBeneficiary);

        policyBeneficiary.setPolicyBeneficiaryBizId(RandomStringGenerator.generateBizId16("policy_beneficiary"));

        Date now = new Date();
        policyBeneficiary.setCreateTime(now);
        policyBeneficiary.setUpdateTime(now);
        // 保存到数据库
        this.saveOrUpdate(policyBeneficiary);

        // 返回结果
        return Collections.singletonMap("policyBeneficiaryBizId", policyBeneficiary.getPolicyBeneficiaryBizId());
    }

    @Override
    public PolicyBeneficiary getByBizId(String policyBeneficiaryBizId) {
        return this.getOne(new QueryWrapper<PolicyBeneficiary>().eq("policy_beneficiary_biz_id", policyBeneficiaryBizId));
    }

    @Override
    public Boolean updatePolicyBeneficiary(PolicyBeneficiaryUpdateRequest policyUpdateRequest) {
        // 校验请求参数
        if (policyUpdateRequest == null) {
            throw new BusinessException(ResultCode.PARAMS_ERROR.getCode(), ResultCode.PARAMS_ERROR.getMessage());
        }
        // 校验 policyBeneficiaryBizId 是否存在
        PolicyBeneficiary policyBeneficiary = this.getByBizId(policyUpdateRequest.getPolicyBeneficiaryBizId());
        if (policyBeneficiary == null) {
            throw new BusinessException(ResultCode.NULL_ERROR.getCode(), ResultCode.NULL_ERROR.getMessage());
        }
        // 转换为实体类
        BeanUtils.copyProperties(policyUpdateRequest, policyBeneficiary, "policyBeneficiaryBizId", "policyBizId", "id");
        policyBeneficiary.setUpdateTime(new Date());

        // 更新数据库
        return this.updateById(policyBeneficiary);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Boolean updatePolicyBeneficiaryList(PolicyBeneficiaryListUpdateRequest policyBeneficiaryUpdateRequest) {
        // 校验请求参数
        if (policyBeneficiaryUpdateRequest == null || StringUtils.isEmpty(policyBeneficiaryUpdateRequest.getPolicyBizId())) {
            throw new BusinessException(ResultCode.PARAMS_ERROR.getCode(), ResultCode.PARAMS_ERROR.getMessage());
        }
        // 先删除旧的受益人
        this.remove(new QueryWrapper<PolicyBeneficiary>().eq("policy_biz_id", policyBeneficiaryUpdateRequest.getPolicyBizId()));
        // 批量插入新的受益人
        if (policyBeneficiaryUpdateRequest.getPolicyBeneficiaryList() != null && !policyBeneficiaryUpdateRequest.getPolicyBeneficiaryList().isEmpty()) {
            this.saveBatch(policyBeneficiaryUpdateRequest.getPolicyBeneficiaryList().stream().map(beneficiaryAddRequest -> {
                PolicyBeneficiary beneficiary = new PolicyBeneficiary();
                BeanUtils.copyProperties(beneficiaryAddRequest, beneficiary);
                beneficiary.setPolicyBeneficiaryBizId(RandomStringGenerator.generateBizId16("policy_beneficiary"));
                beneficiary.setPolicyBizId(policyBeneficiaryUpdateRequest.getPolicyBizId());
                if (CollectionUtils.isNotEmpty(beneficiaryAddRequest.getAddressList())) {
                    beneficiary.setAddressList(GSONUtil.toJson(beneficiaryAddRequest.getAddressList()));
                }
                beneficiary.setCreateTime(new Date());
                beneficiary.setUpdateTime(new Date());
                return beneficiary;
            }).collect(java.util.stream.Collectors.toList()));
        }
        return true;
    }
}




