package com.yd.csf.feign.fallback.conditiontype;

import com.yd.common.result.Result;
import com.yd.csf.feign.client.conditiontype.ApiConditionTypeFeignClient;
import com.yd.csf.feign.request.conditiontype.ApiConditionTypeAddRequest;
import com.yd.csf.feign.request.conditiontype.ApiConditionTypeEditRequest;
import com.yd.csf.feign.request.conditiontype.ApiConditionTypePageRequest;
import com.yd.csf.feign.response.conditiontype.ApiConditionTypeDetailResponse;
import lombok.extern.slf4j.Slf4j;
import org.springframework.cloud.openfeign.FallbackFactory;
import org.springframework.stereotype.Component;

/**
 * 香港保险服务-条件类型信息Feign降级处理
 */
@Slf4j
@Component
public class ApiConditionTypeFeignFallbackFactory implements FallbackFactory<ApiConditionTypeFeignClient> {
    @Override
    public ApiConditionTypeFeignClient create(Throwable cause) {
        return new ApiConditionTypeFeignClient() {
            @Override
            public Result page(ApiConditionTypePageRequest request) {
                return null;
            }

            @Override
            public Result<ApiConditionTypeDetailResponse> detail(String conditionTypeBizId) {
                return null;
            }

            @Override
            public Result add(ApiConditionTypeAddRequest request) {
                return null;
            }

            @Override
            public Result edit(ApiConditionTypeEditRequest request) {
                return null;
            }

            @Override
            public Result del(String conditionTypeBizId) {
                return null;
            }
        };
    }
}
