package com.yd.csf.feign.request.expectedfortune;

import com.yd.common.dto.PageDto;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.time.LocalDate;
import java.util.List;

@Data
public class ApiExpectedFortunePageRequest extends PageDto {
    /**
     * 应付款编号
     */
    @Schema(description = "应付款编号")
    private String payableNo;

    /**
     * 保单号
     */
    @Schema(description = "保单号")
    private String policyNo;

    @Schema(description = "预计出账日期开始")
    private LocalDate payoutDateStart;

    @Schema(description = "预计出账日期结束")
    private LocalDate payoutDateEnd;

    @Schema(description = "出账状态, 可多选 0=待出账 1=可出帐 2=完成出账 3=部分出账 4=保留 5=已失效 字典值: csf_expected_fortune_status")
    private List<String> statusList;

    /**
     * 出账期数(1=第一年; 2=第二年; 3=第三年; 4=第四年; 5=第五年)
     */
    @Schema(description = "出账期数(1=第一年; 2=第二年; 3=第三年; 4=第四年; 5=第五年)")
    private Integer fortunePeriod;

    @Schema(description = "出账项目类型 1=销售佣金;等等 字典值: csf_fortune_type")
    private String fortuneType;

    @Schema(description = "出单团队名称")
    private String team;

    @Schema(description = "出单团队业务ID列表")
    private List<String> teamBizIdList;

    @Schema(description = "保险公司业务ID列表")
    private List<String> insuranceCompanyBizIdList;

    @Schema(description = "产品计划业务ID列表")
    private List<String> productLaunchBizIdList;

    @Schema(description = "转介人业务ID列表")
    private List<String> brokerBizIdList;

    @Schema(description = "签单员业务ID列表")
    private List<String> signerBizIdList;

    @Schema(description = "应付款类型 R-关联保单应付款 U-非关联保单应付款")
    private String fortuneBizType;
}
