package com.yd.csf.service.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 介绍人批量保存请求
 */
@Data
public class BrokerBatchSaveRequest implements Serializable {

    private static final long serialVersionUID = 1L;

    @Schema(description = "新单跟进唯一业务ID", requiredMode = Schema.RequiredMode.REQUIRED)
    private String policyBizId;

    @Schema(description = "介绍人列表")
    private List<BrokerInfo> brokerList;

    @Data
    public static class BrokerInfo implements Serializable {
        private static final long serialVersionUID = 1L;

        @Schema(description = "介绍人姓名")
        private String brokerName;

        @Schema(description = "介绍人业务id")
        private String brokerBizId;

        @Schema(description = "性别")
        private String gender;

        @Schema(description = "内部编号")
        private String internalCode;

        @Schema(description = "所属团队")
        private String team;

        @Schema(description = "团队业务id")
        private String teamBizId;

        @Schema(description = "分配比例")
        private String brokerRatio;

        @Schema(description = "备注")
        private String remark;
    }
}
