package com.yd.csf.service.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yd.csf.feign.request.premiumremittancefile.ApiPremiumRemittanceFilePageRequest;
import com.yd.csf.feign.response.premiumremittancefile.ApiPremiumRemittanceFilePageResponse;
import com.yd.csf.service.model.PremiumRemittance;
import com.yd.csf.service.model.PremiumRemittanceFile;
import com.yd.csf.service.dao.PremiumRemittanceFileMapper;
import com.yd.csf.service.service.IPremiumRemittanceFileService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * <p>
 * 保费汇款记录附件表 服务实现类
 * </p>
 *
 * @author zxm
 * @since 2025-12-26
 */
@Service
public class PremiumRemittanceFileServiceImpl extends ServiceImpl<PremiumRemittanceFileMapper, PremiumRemittanceFile> implements IPremiumRemittanceFileService {

    @Override
    public IPage<ApiPremiumRemittanceFilePageResponse> page(Page<ApiPremiumRemittanceFilePageResponse> page,
                                                            ApiPremiumRemittanceFilePageRequest request) {
        return baseMapper.page(page,request);
    }

    @Override
    public List<PremiumRemittanceFile> queryList(String premiumRemittanceBizId) {
        List<PremiumRemittanceFile> list = baseMapper.selectList(new LambdaQueryWrapper<PremiumRemittanceFile>()
                .eq(StringUtils.isNotBlank(premiumRemittanceBizId),PremiumRemittanceFile::getPremiumRemittanceBizId,premiumRemittanceBizId)
        );
        return list;
    }

    /**
     * 根据保费对账-汇款记录表唯一业务ID删除
     * @param premiumRemittanceBizId
     * @return
     */
    @Override
    public Boolean delByPremiumRemittanceBizId(String premiumRemittanceBizId) {
        return this.remove(new LambdaQueryWrapper<PremiumRemittanceFile>().eq(PremiumRemittanceFile::getPremiumRemittanceBizId,premiumRemittanceBizId));
    }

    /**
     * 查询单个对象
     * @param premiumRemittanceFileBizId
     * @return
     */
    @Override
    public PremiumRemittanceFile queryOne(String premiumRemittanceFileBizId) {
        return this.getOne(new LambdaQueryWrapper<PremiumRemittanceFile>()
                .eq(PremiumRemittanceFile::getPremiumRemittanceBizId,premiumRemittanceFileBizId).last(" limit 1 "));
    }

}
