package com.yd.csf.api.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yd.common.result.Result;
import com.yd.csf.api.service.ApiTeamService;
import com.yd.csf.feign.request.team.ApiTeamListRequest;
import com.yd.csf.feign.request.team.ApiTeamPageRequest;
import com.yd.csf.feign.response.team.ApiTeamDetailResponse;
import com.yd.csf.feign.response.team.ApiTeamPageResponse;
import com.yd.csf.service.dto.TeamDto;
import com.yd.csf.service.model.Team;
import com.yd.csf.service.service.ITeamService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import java.util.List;
import java.util.stream.Collectors;

@Slf4j
@Service
public class ApiTeamServiceImpl implements ApiTeamService {

    @Autowired
    private ITeamService iTeamService;

    /**
     * 分页列表查询-团队信息
     * @param request
     * @return
     */
    @Override
    public Result<IPage<ApiTeamPageResponse>> page(ApiTeamPageRequest request) {
        Page<ApiTeamPageResponse> page = new Page<>(request.getPageNo(), request.getPageSize());
        IPage<ApiTeamPageResponse> iPage = iTeamService.page(page, request);
        return Result.success(iPage);
    }

    /**
     * 列表查询-团队信息
     * @param request
     * @return
     */
    @Override
    public Result<List<ApiTeamDetailResponse>> list(ApiTeamListRequest request) {
        List<Team> teamList = iTeamService.queryList(TeamDto.builder().teamName(request.getTeamName()).build());
        if (CollectionUtils.isEmpty(teamList)) {
            return Result.success();
        }
        List<ApiTeamDetailResponse> responses = teamList.stream().map(dto -> {
            ApiTeamDetailResponse response = new ApiTeamDetailResponse();
            BeanUtils.copyProperties(dto,response);
            return response;
        }).collect(Collectors.toList());
        return Result.success(responses);
    }

}
