package com.yd.csf.service.dto;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

@Data
@Schema(description = "保费负担能力")
public class PremiumAffordability {
    /**
     * 平均月收入
     */
    @Schema(description = "在过去12个月里，你从所有所得的收入来源所得的平均每月收入为?(包括薪金、花红、佣金、其他薪酬红利、银行存款利息、债券利息及股息等")
    private String monthlyIncome;

    /**
     * 平均月支出
     */
    @Schema(description = "过去12个月每月里，你每月的平均开支为?")
    private String monthlyExpense;

    /**
     * 累积流动资产
     */
    @Schema(description = "您现时的累积流动资产约有多少?")
    private String liquidAssets;

    /**
     * 流动资产种类
     */
    @Schema(description = "流动资产种类，多选逗号隔开 字典值：csf_liquid_asset_type")
    private String liquidAssetType;

    /**
     * 其他流动资产的说明
     */
    @Schema(description = "其他流动资产的说明")
    private String otherLiquidAsset;

    @Schema(description = "首期及续保保费的财富来源，单选 字典值：csf_premium_funding_source")
    private String premiumFundingSource;
}
